<?php
if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class DN_Blocks_List_Table extends WP_List_Table {
    public function __construct() {
        parent::__construct([
            'singular' => 'block',
            'plural'   => 'blocks',
            'ajax'     => false
        ]);
    }

    public function get_columns() {
        return [
            'title'       => 'Block Title',
            'short_code'  => 'Block Short Code',
            'sort_order'  => 'Sort Order',
            'created_by'  => 'Created By',
            'created_at'  => 'Created At',
            'updated_by'  => 'Updated By',
            'updated_at'  => 'Updated At',
        ];
    }

    protected function get_sortable_columns() {
        return [
            'title'      => ['title', true],
            'sort_order' => ['sort_order', false],
            'created_at' => ['created_at', false],
            'updated_at' => ['updated_at', false]
        ];
    }

    public function prepare_items() {
        global $wpdb;
        $table_name = $wpdb->prefix . 'blocks';
        $current_page = $this->get_pagenum();
        $per_page = 10;
        $offset = ($current_page - 1) * $per_page;

        // Arama ve Sıralama
        $search = isset($_REQUEST['s']) ? sanitize_text_field($_REQUEST['s']) : '';
        $orderby = !empty($_GET['orderby']) ? $_GET['orderby'] : 'sort_order';
        $order = !empty($_GET['order']) ? strtoupper($_GET['order']) : 'ASC';

        // Sütun ve Sıralama Kontrolü
        $allowed_columns = ['title', 'sort_order', 'created_at', 'updated_at'];
        $orderby = in_array($orderby, $allowed_columns) ? $orderby : 'sort_order';
        $order = in_array($order, ['ASC', 'DESC']) ? $order : 'ASC';

        // WHERE Koşulu
        $where = '';
        if (!empty($search)) {
            $where = $wpdb->prepare(" WHERE title LIKE %s", '%' . $wpdb->esc_like($search) . '%');
        }

        // Veri Sorgusu
        $sql = "SELECT * FROM $table_name $where ORDER BY $orderby $order LIMIT %d OFFSET %d";
        $sql = $wpdb->prepare($sql, $per_page, $offset);
        $this->items = $wpdb->get_results($sql, OBJECT);

        // Toplam Kayıt
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $where");

        // Pagination
        $this->set_pagination_args([
            'total_items' => $total_items,
            'per_page'    => $per_page,
            'total_pages' => ceil($total_items / $per_page)
        ]);
    }

    protected function column_default($item, $column_name) {
        switch ($column_name) {
            case 'title':
                return '<a href="admin.php?page=dn-blocks-new&id=' . $item->id . '">' . esc_html($item->title) . '</a>';
            case 'short_code':
                return '[dn_block id="' . $item->id . '"]';
            case 'sort_order':
                return esc_html($item->sort_order);
            case 'created_by':
                return esc_html(get_userdata($item->created_by)->display_name);
            case 'created_at':
                return esc_html($item->created_at);
            case 'updated_by':
                return esc_html(get_userdata($item->updated_by)->display_name);
            case 'updated_at':
                return esc_html($item->updated_at);
            default:
                return '-';
        }
    }
}