<?php
/**
 * Plugin Name: DN Blocks
 * Description: Özel bloklarınızı oluşturabileceğiniz ve yönetebileceğiniz bir eklenti.
 * Version: 1.0
 * Author: Designneuro
 */

if (!defined('ABSPATH')) {
    exit;
}

require_once 'includes/admin-views/class-wp-list-table.php';

function dn_blocks_admin_menu() {
    add_menu_page('DN Blocks', 'DN Blocks', 'manage_options', 'dn-blocks', 'dn_blocks_list_page', 'dashicons-screenoptions', 25);
    add_submenu_page('dn-blocks', 'Blocks', 'Blocks', 'manage_options', 'dn-blocks', 'dn_blocks_list_page');
    add_submenu_page('dn-blocks', 'New Block', 'New Block', 'manage_options', 'dn-blocks-new', 'dn_blocks_new_page');
}
add_action('admin_menu', 'dn_blocks_admin_menu');


function dn_blocks_list_page() {
    // Duplicate işlemini kontrol et
    if (isset($_GET['action']) && $_GET['action'] === 'duplicate' && isset($_GET['block'])) {
        dn_duplicate_block(intval($_GET['block']));
    }

    require_once plugin_dir_path(__FILE__) . 'includes/class-blocks-list-table.php';
    
    $blocks_table = new Blocks_List_Table();
    $blocks_table->prepare_items();
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">DN Blocks</h1>
        <a href="admin.php?page=dn-blocks-new" class="page-title-action">New Block</a>
        <hr class="wp-header-end">
        
        <form id="posts-filter" method="get">
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page']; ?>" />
            <?php
            $blocks_table->search_box('Search Blocks', 'block');
            $blocks_table->display();
            ?>
        </form>
    </div>
    <?php
}

function dn_blocks_new_page() {
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.'));
    }

    include plugin_dir_path(__FILE__) . 'includes/admin-views/form.php';
}

function dn_blocks_enqueue_admin_assets($hook) {
    if (strpos($hook, 'dn-blocks') === false) {
        return;
    }
    wp_enqueue_media();

    wp_enqueue_script('fontawesome', plugin_dir_url(__FILE__) . 'scripts/font-awesome/js/fontawesome.js');
    wp_enqueue_style('fontawesome', plugin_dir_url(__FILE__) . 'scripts/font-awesome/css/font-awesome.min.css');

    wp_enqueue_script('jquery-ui-dialog');
    wp_enqueue_script('custom-js', plugin_dir_url(__FILE__) . 'scripts/dn-block.js', ['jquery'], '', true);
    wp_enqueue_style('dn-block', plugin_dir_url(__FILE__) . 'scripts/dn-block.css');

    wp_enqueue_style('select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css');

    wp_enqueue_script('select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js', array('jquery'), '', true);

    wp_add_inline_script('select2-js', '
        jQuery(document).ready(function($) {
            $(".select2").select2();
        });
    ');
}
add_action('admin_enqueue_scripts', 'dn_blocks_enqueue_admin_assets');

register_activation_hook(__FILE__, function() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = $wpdb->prefix . 'blocks';

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL,
        title text,
        subtitle text,
        description longtext,
        description_2 longtext,
        language_id varchar(10),
        block_type varchar(50),
        button_link varchar(255),
        button_text varchar(255),
        status tinyint(1) DEFAULT 1,
        image varchar(255),
        mobile_image varchar(255),
        data longtext,
        created_at timestamp DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
});


function dn_save_block() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';

    // Kullanıcı yetkisi kontrolü
    if (!current_user_can('manage_options')) {
        wp_die('Yetkisiz işlem.');
    }

    // Nonce kontrolü
    if (!isset($_POST['dn_save_block_nonce_field']) || !wp_verify_nonce($_POST['dn_save_block_nonce_field'], 'dn_save_block_nonce')) {
        wp_die('Geçersiz nonce.');
    }

    // Form verilerini al
    $block_id       = isset($_POST['block_id']) ? intval($_POST['block_id']) : 0;
    $name           = sanitize_text_field(stripslashes($_POST['name']));
    $title          = sanitize_text_field(stripslashes($_POST['title']));
    $subtitle       = sanitize_text_field(stripslashes($_POST['subtitle']));
    $description    = sanitize_textarea_field(stripslashes($_POST['description']));
    $description_2  = sanitize_textarea_field(stripslashes($_POST['description_2']));
    $language_id    = sanitize_text_field($_POST['language_id']);
    $block_type     = sanitize_text_field($_POST['block_type']);
    $button_link    = esc_url_raw($_POST['button_link']);
    $button_text    = sanitize_text_field(stripslashes($_POST['button_text']));
    $status         = intval($_POST['status']);
    $image          = sanitize_text_field($_POST['image']);
    $mobile_image   = sanitize_text_field($_POST['mobile_image']);
    $data           = sanitize_textarea_field($_POST['data']);
    $user_id        = get_current_user_id();
    $created_at     = current_time('mysql');



    if ($block_id) {
        // Güncelleme
        $wpdb->update(
            $table_name,
            [
                'name'          => $name,
                'title'         => $title,
                'subtitle'      => $subtitle,
                'description'   => $description,
                'description_2' => $description_2,
                'language_id'   => $language_id,
                'block_type'    => $block_type,
                'button_link'   => $button_link,
                'button_text'   => $button_text,
                'status'        => $status,
                'image'         => $image,
                'mobile_image'  => $mobile_image,
                'data'          => $data,
                'updated_by'    => $user_id,
                'updated_at'    => $created_at

            ],
            ['id' => $block_id]
        );
    } else {
        $fields = [
            'name'          => $name,
            'title'         => $title,
            'subtitle'      => $subtitle,
            'description'   => $description,
            'description_2' => $description_2,
            'language_id'   => $language_id,
            'block_type'    => $block_type,
            'button_link'   => $button_link,
            'button_text'   => $button_text,
            'status'        => $status,
            'image'         => $image,
            'mobile_image'  => $mobile_image,
            'data'          => $data,
            'created_by'    => $user_id,
            'updated_by'    => $user_id,
            'created_at'    => $created_at,

            'updated_at'    => $created_at
        ];
        // Yeni ekleme
        $wpdb->insert(
            $table_name,
            $fields
        );
    }

    wp_redirect(admin_url('admin.php?page=dn-blocks'));
    exit;
}

add_action('admin_post_dn_save_block', 'dn_save_block');
add_action('admin_post_nopriv_dn_save_block', 'dn_save_block');

function get_locale_name($locale) {
    $locales = array(
        'en' => 'English',
        'tr' => 'Türkçe',
    );

    return isset($locales[$locale]) ? $locales[$locale] : $locale;
}

function block_types($key = "") {
    $types = array(
        'product-category-slideshow' => 'Product Category Slideshow',
        '2-column-product-listing' => '2-Column Product Listing',
        'home-slider' => 'Home Full Width Slider',
        'banner-collapse' => 'Banner Collapse',
        '3-column-product-slideshow' => '3-Column and Slideshow Products',
        'banner-full-width-slider' => 'Banner Full Width Slider',
        'story-slideshow' => 'Story Slideshow',
        'story-tree-pack' => 'Story 3-pack',
        'full-with-banner-and-center-text' => 'Full with Banner and Center Text',
        'background_default_and_banner_text' => 'Background Default and Banner-Text',
        'full_with_banner_and_left_text' => 'Full with Banner and Left Text',
        'proportional_3_column_visual' => 'Proportional 3 column visual',
        'container-with-banner-video' => 'Container with Banner Video',
        'faq' => 'FAQ',
        'right-banner-and-content-collapse' => 'Right Banner and Content Collapse',
        'warning-text' => 'Warning Text',
        'recipes' => 'Recipes Video and Image',
        'left-collapse-and-right-banner-text' => 'Left Collapse and Right Banner Text',
        'product-nutrition-icons' => 'Product Nutrition Icons',
        'comments' => 'Customer Comments',
        'comments-all' => 'All Comments',
        'scroll-product-night' => 'Scroll Product Night',
    );



    if (isset($types[$key]) && $types[$key])
        return $types[$key];

    return $types;
}

function get_all_products_for_select() {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
    );

    $query = new WP_Query($args);
    $products = $query->posts;

    return $products;
}


add_action('wp_ajax_fetch_products', 'fetch_products');
add_action('wp_ajax_nopriv_fetch_products', 'fetch_products');

function fetch_products() {
    global $wpdb;

    $query = isset($_GET['query']) ? sanitize_text_field($_GET['query']) : '';

    $args = array(
        'post_type' => 'product',
        'posts_per_page' => 4,
    );

    if ($query) {
        $args["s"] = $query;
        $args["posts_per_page"] = 100;
    }

    $products = new WP_Query($args);

    $product_data = array();
    if ($products->have_posts()) {
        while ($products->have_posts()) {
            $products->the_post();
            $product_data[] = array(
                'id' => get_the_ID(),
                'title' => get_the_title()
            );
        }
    }

    wp_send_json_success(array('data' => $product_data));
}

//function enqueue_ajax_script() {
//    wp_add_inline_script('jquery', 'ajaxurl', admin_url('admin-ajax.php'));
//}

function enqueue_ajax_script() {
    wp_add_inline_script('jquery', 'var ajaxurl = "' . admin_url('admin-ajax.php') . '";');
}


add_action('wp_enqueue_scripts', 'enqueue_ajax_script');

function dn_duplicate_block($block_id) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';

    // Güvenlik kontrolü
    if (!current_user_can('manage_options')) {
        wp_die('You do not have sufficient permissions to access this page.');
    }

    // Orijinal bloğu al
    $original_block = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $block_id));

    if ($original_block) {
        // ID'yi kaldır ve yeni tarih/kullanıcı bilgilerini ayarla
        unset($original_block->id);
        $original_block->name = $original_block->name . ' (Copy)';
        $original_block->created_by = get_current_user_id();
        $original_block->updated_by = get_current_user_id();
        $original_block->created_at = current_time('mysql');
        $original_block->updated_at = current_time('mysql');

        // Yeni kaydı oluştur
        $wpdb->insert(
            $table_name,
            (array) $original_block,
            [
                '%s', // language_id
                '%s', // name
                '%s', // title
                '%s', // subtitle
                '%s', // description
                '%s', // description_2
                '%s', // button_text
                '%s', // button_link
                '%s', // block_type
                '%s', // data
                '%d', // status
                '%d', // created_by
                '%d', // updated_by
                '%s', // created_at
                '%s'  // updated_at
            ]
        );

        if ($wpdb->insert_id) {
            // Başarılı mesajı için admin_notice ekle
            add_action('admin_notices', function() {
                echo '<div class="notice notice-success is-dismissible"><p>Block successfully duplicated.</p></div>';
            });
        } else {
            // Hata mesajı için admin_notice ekle
            add_action('admin_notices', function() {
                echo '<div class="notice notice-error is-dismissible"><p>Error duplicating block.</p></div>';
            });
        }
    }

    // Listeye geri dön
    wp_redirect(admin_url('admin.php?page=dn-blocks'));
    exit;
}
