<?php
/**
 * Login Form
 */

if (!defined('ABSPATH')) {
	exit;
}

// Register sayfasına yönlendirme kontrolü
if (isset($_GET['action']) && $_GET['action'] === 'register') {
	wc_get_template('myaccount/form-register.php');
	return;
}

do_action('woocommerce_before_customer_login_form'); 

?>


<script>
	if (window.innerWidth <= 768) {
		document.querySelector(".header-all").classList.add("header-relative");
	}
</script>
<style>
	@media only screen and (max-width: 768px) {
		.header-all {
			background-color: #ffffff;
		}

		body {
			background: #ffffff;
		}
	}

	footer, .woocommerce-error { 
		display: none;
	}
</style>

<section class="section-login">
	<div class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-slideshow="animation: fade">
		<div class="uk-slideshow-items">
			<div>
				<div class="uk-position-relative uk-overflow-hidden">
					<div class="uk-position-relative uk-position-z-index-negative banner-image uk-visible@m" 
						 style="background-image: url('<?php bloginfo('template_url'); ?>/assets/image/intro.jpg');"></div>
					<div class="uk-position-relative uk-position-z-index-negative banner-mobile-image uk-hidden@m"></div>

					<div class="banner-contents uk-position-absolute uk-position-z-index-2">
						<div class="custom-container">
							<div class="uk-grid align-items-center">
								<div class="uk-width-3-12@xxl uk-width-4-11@m">
									<form method="post" class="woocommerce-form woocommerce-form-login login login-form">
										<?php do_action('woocommerce_login_form_start'); ?>

										<h1><?php esc_html_e('Giriş Yap', 'leanfit'); ?></h1>
										<p><?php esc_html_e('İlk alışverişinizde 150 TL indirim kodu ve daha özel tekliflerin tadını çıkarın!', 'leanfit'); ?></p>

										<div class="uk-margin form-floating">
											<input type="text" class="uk-input woocommerce-Input" 
												   name="username" id="username" 
												   autocomplete="username"
												   placeholder=" "
												   value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" 
												   required />
											<label for="username"><?php esc_html_e('Kullanıcı Adı / E-posta', 'leanfit'); ?></label>
										</div>

										<div class="uk-margin form-floating">
											<input class="uk-input woocommerce-Input" type="password" 
												   name="password" id="password" 
												   autocomplete="current-password"
												   placeholder=" "
												   required />
											<label for="password"><?php esc_html_e('Şifre', 'leanfit'); ?></label>
											<span class="show-password-input">
												<span class="eye-on" uk-icon="icon: icn-eye-on; ratio: 1.5"></span>
												<span class="eye-off" uk-icon="icon: icn-eye-off; ratio: 1.5"></span>
											</span>
										</div>

										<?php do_action('woocommerce_login_form'); ?>

										<div class="uk-flex uk-flex-between uk-margin">
											<div>
												<label>
													<input class="uk-checkbox has uk-margin-remove" name="rememberme" 
														   type="checkbox" id="rememberme" value="forever">
													&nbsp; <?php esc_html_e('Beni Hatırla', 'leanfit'); ?>
												</label>
											</div>

											<div>
												<a href="<?php echo esc_url(wp_lostpassword_url()); ?>" 
												   class="uk-button uk-button-text forgot-link">
													<?php esc_html_e('Şifrenizi mi unuttunuz?', 'leanfit'); ?>
												</a>
											</div>
										</div>

										<?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>

										<div class="uk-text-center">
											<button type="submit" class="uk-button login-button" 
													name="login" value="<?php esc_attr_e('Giriş Yap', 'leanfit'); ?>">
												<?php esc_html_e('Giriş Yap', 'leanfit'); ?>
											</button>
										</div>

										<hr class="uk-hr">

										<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) : ?>
											<div class="uk-text-center">
												<a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>?action=register" 
												   class="uk-button sign-up-button">
													<?php esc_html_e('Üye Ol', 'leanfit'); ?>
												</a>
											</div>
										<?php endif; ?>

										<?php do_action('woocommerce_login_form_end'); ?>

									
										<div class="uk-text-left login-error"></div>
									</form>

								</div>
								<div class="uk-width-2-11@xxl uk-width-1-11@m uk-visible@m"></div>
								<div class="uk-width-3-10@xxl uk-width-4-10@xl uk-width-4-11@m uk-visible@m uk-light">
									<h2><?php esc_html_e('Fitness Yolculuğunuzu Hızlandırın', 'leanfit'); ?></h2>
									<h3 class=""><?php esc_html_e('Sınırlı Bir Süre İçin Tüm Doğal Protein Tozlarında %20 İndirim!', 'leanfit'); ?></h3>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<script>
	$('.woocommerce-error li').each(function() {
		var errorMessage = $(this).text();
		$('.login-error').addClass('uk-margin-medium-top');
		$('.login-error').append('<div class="uk-alert-danger" uk-alert><a href class="uk-alert-close" uk-close></a><p class="uk-margin-remove">' + errorMessage + '</p></div>');
	});
</script>

<?php do_action('woocommerce_after_customer_login_form'); ?>
