<?php
/**
 * Review order table
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/review-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="order-reviews">
    <?php
    do_action('woocommerce_review_order_before_cart_contents');?>

			


            <?php do_action('woocommerce_review_order_after_cart_contents'); ?>
</div>

<?php // Sepet özeti için gizli tablo - JavaScript ile toplam tutarları almak için kullanılacak ?>
<table class="shop_table woocommerce-checkout-review-order-table" style="display: none;">
    <tfoot>
        <tr class="cart-subtotal">
            <th><?php esc_html_e('Subtotal', 'woocommerce'); ?></th>
            <td><?php wc_cart_totals_subtotal_html(); ?></td>
        </tr>

        <?php foreach (WC()->cart->get_coupons() as $code => $coupon) : ?>
            <tr class="cart-discount coupon-<?php echo esc_attr(sanitize_title($code)); ?>">
                <th><?php wc_cart_totals_coupon_label($coupon); ?></th>
                <td><?php wc_cart_totals_coupon_html($coupon); ?></td>
            </tr>
        <?php endforeach; ?>

        <?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>
            <?php do_action('woocommerce_review_order_before_shipping'); ?>
            <?php wc_cart_totals_shipping_html(); ?>
            <?php do_action('woocommerce_review_order_after_shipping'); ?>
        <?php endif; ?>

        <?php foreach (WC()->cart->get_fees() as $fee) : ?>
            <tr class="fee">
                <th><?php echo esc_html($fee->name); ?></th>
                <td><?php wc_cart_totals_fee_html($fee); ?></td>
            </tr>
        <?php endforeach; ?>

        <?php if (wc_tax_enabled() && !WC()->cart->display_prices_including_tax()) : ?>
            <?php if ('itemized' === get_option('woocommerce_tax_total_display')) : ?>
                <?php foreach (WC()->cart->get_tax_totals() as $code => $tax) : ?>
                    <tr class="tax-rate tax-rate-<?php echo esc_attr(sanitize_title($code)); ?>">
                        <th><?php echo esc_html($tax->label); ?></th>
                        <td><?php echo wp_kses_post($tax->formatted_amount); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr class="tax-total">
                    <th><?php echo esc_html(WC()->countries->tax_or_vat()); ?></th>
                    <td><?php wc_cart_totals_taxes_total_html(); ?></td>
                </tr>
            <?php endif; ?>
        <?php endif; ?>

        <?php do_action('woocommerce_review_order_before_order_total'); ?>

        <tr class="order-total">
            <th><?php esc_html_e('Total', 'woocommerce'); ?></th>
            <td><?php wc_cart_totals_order_total_html(); ?></td>
        </tr>

        <?php do_action('woocommerce_review_order_after_order_total'); ?>
    </tfoot>
</table>

<script type="text/javascript">
jQuery(function($) {
    // Miktar güncelleme işlemleri
     {
        e.preventDefault();
        var $input = $(this).closest('.quantity-buttons').find('.qty-value');
        var currentVal = parseInt($input.val());
        var cartKey = $input.data('cart-key');
        
        if ($(this).hasClass('minus') && currentVal > 1) {
            $input.val(currentVal).trigger('change');
        } else if ($(this).hasClass('plus')) {
            $input.val(currentVal).trigger('change');
        }
    });

    // Miktar değişikliğinde AJAX ile güncelleme
    $('.qty-value').on('change', function() {
        var $this = $(this);
        var cartKey = $this.data('cart-key');
        var qty = $this.val();

        // Blok efekti ekle
        $this.closest('.checkout-cart-item').block({
            message: null,
            overlayCSS: {
                background: '#fff',
                opacity: 0.6
            }
        });

        $.ajax({
            type: 'POST',
            url: wc_checkout_params.ajax_url,
            data: {
                action: 'update_cart_item_quantity',
                cart_item_key: cartKey,
                quantity: qty,
                security: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
                    // Checkout'u güncelle
                    $('body').trigger('update_checkout');
                }
            },
            complete: function() {
                // Blok efektini kaldır
                $this.closest('.checkout-cart-item').unblock();
            }
        });
    });

    // Ürün silme işlemi
    $(document).on('click', '.cart-remove a', function(e) {
        e.preventDefault();
        var $this = $(this);
        var $item = $this.closest('.checkout-cart-item');

        $item.block({
            message: null,
            overlayCSS: {
                background: '#fff',
                opacity: 0.6
            }
        });

        $.ajax({
            type: 'GET',
            url: $this.attr('href'),
            success: function() {
                $('body').trigger('update_checkout');
                $item.remove();
            }
        });
    });
});
</script>
