<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Kullanıcı giriş yapmamışsa login sayfasına yönlendir
if ( ! is_user_logged_in() ) {
    wp_redirect( wc_get_page_permalink( 'myaccount' ) );
    exit;
}

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}

global $wpdb;
$user_id = get_current_user_id();

// İl bazlı posta kodları array'i
$city_postcodes = array(
    'Adana' => '01000',
    'Adıyaman' => '02000',
    'Afyon' => '03000',
    'Ağrı' => '04000',
    'Amasya' => '05000',
    'Ankara' => '06000',
    'Antalya' => '07000',
    'Artvin' => '08000',
    'Aydın' => '09000',
    'Balıkesir' => '10000',
    'Bilecik' => '11000',
    'Bingöl' => '12000',
    'Bitlis' => '13000',
    'Bolu' => '14000',
    'Burdur' => '15000',
    'Bursa' => '16000',
    'Çanakkale' => '17000',
    'Çankırı' => '18000',
    'Çorum' => '19000',
    'Denizli' => '20000',
    'Diyarbakır' => '21000',
    'Edirne' => '22000',
    'Elazığ' => '23000',
    'Erzincan' => '24000',
    'Erzurum' => '25000',
    'Eskişehir' => '26000',
    'Gaziantep' => '27000',
    'Giresun' => '28000',
    'Gümüşhane' => '29000',
    'Hakkari' => '30000',
    'Hatay' => '31000',
    'Isparta' => '32000',
    'Mersin' => '33000',
    'İstanbul' => '34000',
    'İzmir' => '35000',
    'Kars' => '36000',
    'Kastamonu' => '37000',
    'Kayseri' => '38000',
    'Kırklareli' => '39000',
    'Kırşehir' => '40000',
    'Kocaeli' => '41000',
    'Konya' => '42000',
    'Kütahya' => '43000',
    'Malatya' => '44000',
    'Manisa' => '45000',
    'Kahramanmaraş' => '46000',
    'Mardin' => '47000',
    'Muğla' => '48000',
    'Muş' => '49000',
    'Nevşehir' => '50000',
    'Niğde' => '51000',
    'Ordu' => '52000',
    'Rize' => '53000',
    'Sakarya' => '54000',
    'Samsun' => '55000',
    'Siirt' => '56000',
    'Sinop' => '57000',
    'Sivas' => '58000',
    'Tekirdağ' => '59000',
    'Tokat' => '60000',
    'Trabzon' => '61000',
    'Tunceli' => '62000',
    'Şanlıurfa' => '63000',
    'Uşak' => '64000',
    'Van' => '65000',
    'Yozgat' => '66000',
    'Zonguldak' => '67000',
    'Aksaray' => '68000',
    'Bayburt' => '69000',
    'Karaman' => '70000',
    'Kırıkkale' => '71000',
    'Batman' => '72000',
    'Şırnak' => '73000',
    'Bartın' => '74000',
    'Ardahan' => '75000',
    'Iğdır' => '76000',
    'Yalova' => '77000',
    'Karabük' => '78000',
    'Kilis' => '79000',
    'Osmaniye' => '80000',
    'Düzce' => '81000'
);

// Seçili fatura adresini getir
$selected_billing_address = $wpdb->get_row($wpdb->prepare(
    "SELECT a.*, 
        i.il_adi as city_name,
        il.ilce_adi as district_name,
        s.semt_adi as neighborhood_name
    FROM {$wpdb->prefix}user_addresses a
    LEFT JOIN {$wpdb->prefix}iller i ON i.id = a.city_id
    LEFT JOIN {$wpdb->prefix}ilceler il ON il.id = a.district_id
    LEFT JOIN {$wpdb->prefix}semtler s ON s.id = a.neighborhood_id
    WHERE a.user_id = %d 
    AND a.address_type = 'billing'
    AND a.is_selected = 1",
    $user_id
));

// Tüm fatura adreslerini getir
$billing_addresses = $wpdb->get_results($wpdb->prepare(
    "SELECT a.*, 
        i.il_adi as city_name,
        il.ilce_adi as district_name,
        s.semt_adi as neighborhood_name
    FROM {$wpdb->prefix}user_addresses a
    LEFT JOIN {$wpdb->prefix}iller i ON i.id = a.city_id
    LEFT JOIN {$wpdb->prefix}ilceler il ON il.id = a.district_id
    LEFT JOIN {$wpdb->prefix}semtler s ON s.id = a.neighborhood_id
    WHERE a.user_id = %d 
    AND a.address_type = 'billing'
    ORDER BY a.is_selected DESC, a.id ASC",
    $user_id
));

// Seçili teslimat adresini getir
$selected_shipping_address = $wpdb->get_row($wpdb->prepare(
    "SELECT a.*, 
        i.il_adi as city_name,
        il.ilce_adi as district_name,
        s.semt_adi as neighborhood_name
    FROM {$wpdb->prefix}user_addresses a
    LEFT JOIN {$wpdb->prefix}iller i ON i.id = a.city_id
    LEFT JOIN {$wpdb->prefix}ilceler il ON il.id = a.district_id
    LEFT JOIN {$wpdb->prefix}semtler s ON s.id = a.neighborhood_id
    WHERE a.user_id = %d 
    AND a.address_type = 'shipping'
    AND a.is_selected = 1",
    $user_id
));

// Tüm teslimat adreslerini getir
$shipping_addresses = $wpdb->get_results($wpdb->prepare(
    "SELECT a.*, 
        i.il_adi as city_name,
        il.ilce_adi as district_name,
        s.semt_adi as neighborhood_name
    FROM {$wpdb->prefix}user_addresses a
    LEFT JOIN {$wpdb->prefix}iller i ON i.id = a.city_id
    LEFT JOIN {$wpdb->prefix}ilceler il ON il.id = a.district_id
    LEFT JOIN {$wpdb->prefix}semtler s ON s.id = a.neighborhood_id
    WHERE a.user_id = %d 
    AND a.address_type = 'shipping'
    ORDER BY a.is_selected DESC, a.id ASC",
    $user_id
));

?>

<script>
	document.querySelector(".header-all").classList.add("header-relative");
</script>
<style>
	@media only screen and (max-width: 768px) {
		.header-all {
			background-color: #ffffff;
		}
		footer {
			display: none;
		}
		.woocommerce-notices-wrapper {
			display: none;
		}
	}
	.woocommerce-checkout-payment {
		display: none;
	}
</style>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data" aria-label="<?php echo esc_attr__( 'Checkout', 'woocommerce' ); ?>">

	<?php wp_nonce_field('woocommerce-process_checkout', 'woocommerce-process-checkout-nonce'); ?>

	<?php if (!$checkout->is_registration_required() && $checkout->is_registration_enabled()) : ?>
		<div class="create-account">
			<p><label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
				<input class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" id="createaccount" type="checkbox" name="createaccount" value="1" /> 
				<span><?php esc_html_e('Create an account?', 'woocommerce'); ?></span>
			</label></p>
		</div>
	<?php endif; ?>

	
<div class="hidden-address-fields" style="display: none;">
    <?php if ($selected_billing_address) : ?>
        <?php
        $billing_postcode = isset($city_postcodes[$selected_billing_address->city_name]) ? $city_postcodes[$selected_billing_address->city_name] : '00000';
        ?>
        <input type="hidden" name="billing_first_name" id="billing_first_name" value="<?php echo esc_attr($selected_billing_address->first_name); ?>">
        <input type="hidden" name="billing_last_name" id="billing_last_name" value="<?php echo esc_attr($selected_billing_address->last_name); ?>">
        <input type="hidden" name="billing_country" id="billing_country" value="TR">
        <input type="hidden" name="billing_address_1" id="billing_address_1" value="<?php echo esc_attr($selected_billing_address->address_1); ?>">
        <input type="hidden" name="billing_state" id="billing_state" value="<?php echo esc_attr($selected_billing_address->city_name); ?>">
        <input type="hidden" name="billing_city" id="billing_city" value="<?php echo esc_attr($selected_billing_address->city_name); ?>">
		<input type="hidden" name="billing_address_2" id="billing_address_2" value="<?php echo esc_attr($selected_billing_address->district_name); ?>">
        <input type="hidden" name="billing_postcode" id="billing_postcode" value="<?php echo esc_attr($billing_postcode); ?>">
        <input type="hidden" name="billing_email" id="billing_email" value="<?php echo esc_attr(wp_get_current_user()->user_email); ?>">
        <input type="hidden" name="billing_phone" id="billing_phone" value="<?php echo esc_attr($selected_billing_address->phone); ?>">
    <?php endif; ?>

    <?php if ($selected_shipping_address) : ?>
        <?php
        $shipping_postcode = isset($city_postcodes[$selected_shipping_address->city_name]) ? $city_postcodes[$selected_shipping_address->city_name] : '00000';
        ?>
        <input type="hidden" name="shipping_first_name" id="shipping_first_name" value="<?php echo esc_attr($selected_shipping_address->first_name); ?>">
        <input type="hidden" name="shipping_last_name" id="shipping_last_name" value="<?php echo esc_attr($selected_shipping_address->last_name); ?>">
        <input type="hidden" name="shipping_country" id="shipping_country" value="TR">
        <input type="hidden" name="shipping_address_1" id="shipping_address_1" value="<?php echo esc_attr($selected_shipping_address->address_1); ?>">
        <input type="hidden" name="shipping_state" id="shipping_state" value="<?php echo esc_attr($selected_shipping_address->city_name); ?>">
        <input type="hidden" name="shipping_city" id="shipping_city" value="<?php echo esc_attr($selected_shipping_address->city_name); ?>">
		<input type="hidden" name="shipping_address_2" id="shipping_address_2" value="<?php echo esc_attr($selected_shipping_address->district_name); ?>">
        <input type="hidden" name="shipping_postcode" id="shipping_postcode" value="<?php echo esc_attr($shipping_postcode); ?>">
        <input type="hidden" name="shipping_phone" id="shipping_phone" value="<?php echo esc_attr($selected_shipping_address->phone); ?>">
    <?php endif; ?>
</div>

	<section class="section-checkout">
		<div class="custom-container uk-margin-medium-top uk-margin-medium-bottom">
			<div class="uk-grid-large" uk-grid>
				<!-- Main Content -->
				<div class="uk-width-8-11@l">
					<!-- Basket Section -->
					<section>
						<h2 class="section-title uk-margin-remove-bottom"><?php esc_html_e('Sepet', 'leanfit'); ?></h2>
						<div id="order_review" class="woocommerce-checkout-review-order">
							<?php
							foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
								$_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);

								if ($_product && $_product->exists() && $cart_item['quantity'] > 0) {
									$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
									
									// Ürün fiyatlarını hesapla
									$regular_price = $_product->get_regular_price();
									$sale_price = $_product->get_sale_price();
									$current_price = $_product->get_price();
									
									// İndirim oranını hesapla
									$discount_percentage = 0;
									if ($regular_price > 0 && $sale_price) {
										$discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
									}
							?>

							<div class="uk-card uk-card-small uk-border-0 checkout-cart-item">
								<div class="uk-card-body uk-padding-remove">
									<div class="uk-grid-xsmall uk-flex-middle uk-flex-between uk-grid" uk-grid="">
										<div class="uk-width-5-8@xxl uk-width-5-9@l uk-width-7-11 uk-first-column">
											<div class="uk-grid uk-flex-middle uk-grid-xsmall uk-width-1-1">
												<div class="uk-width-auto">
													<?php if ($product_permalink) : ?>
														<a href="<?php echo esc_url($product_permalink); ?>">
															<?php echo $_product->get_image('woocommerce_thumbnail', ['class' => 'uk-border-rounded']); ?>
														</a>
													<?php else : ?>
														<?php echo $_product->get_image('woocommerce_thumbnail', ['class' => 'uk-border-rounded']); ?>
													<?php endif; ?>
												</div>
												<div class="uk-width-8-9@xxl uk-width-7-9@xl uk-width-6-9">
													<div class="uk-grid uk-grid-small uk-flex-between align-items-center">
														<div class="uk-width-3-5@m">
															<h3 class="uk-h4 uk-margin-remove checkout-product-name">
																<?php echo wp_kses_post(apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key)); ?>
															</h3>
														</div>
														<div class="uk-width-2-5@m">
															<div class="quantity-control">
																<span class="checkout-quantity"><?php esc_html_e('Adet', 'leanfit'); ?></span>
																<div class="uk-button-group quantity-buttons" data-id="<?php echo esc_attr($_product->get_id()); ?>" data-cart-key="<?php echo esc_attr($cart_item_key); ?>">
																	<button type="button" class="uk-button uk-button-small qty-btn minus">-</button>
																	<input type="text" 
																		class="uk-button uk-button-small qty-value has" 
																		value="<?php echo esc_attr($cart_item['quantity']); ?>"
																		data-cart-key="<?php echo esc_attr($cart_item_key); ?>"
																		readonly
																	>
																	<button type="button" class="uk-button uk-button-small qty-btn plus">+</button>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div class="uk-width-3-11@xxl uk-width-4-11@xl uk-width-3-11 uk-text-right">
											<div class="uk-grid uk-flex-center@m uk-flex-between uk-grid-small align-items-center">
												<?php if ($sale_price) : ?>
													<span class="order-price"><?php echo wc_price($sale_price); ?></span>
													<span class="order-discount-price"><?php echo wc_price($regular_price); ?></span>
													<?php if ($discount_percentage > 0) : ?>
														<span class="order-discount-rate">%<?php echo $discount_percentage; ?> <?php esc_html_e('İndirim', 'leanfit'); ?></span>
													<?php endif; ?>
												<?php else : ?>
													<span class="order-price"><?php echo wc_price($current_price); ?></span>
												<?php endif; ?>
											</div>
										</div>
										<div class="uk-width-auto uk-text-right cart-remove">
											<?php
											echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
												'<a href="%s" aria-label="%s" data-product_id="%s" data-product_sku="%s"><span uk-icon="icon: icn-close"></span></a>',
												esc_url(wc_get_cart_remove_url($cart_item_key)),
												"",
												esc_attr($_product->get_id()),
												esc_attr($_product->get_sku())
											), $cart_item_key);
											?>
										</div>
									</div>
								</div>
							</div>
							<?php
								}
							}
							?>
							<?php do_action('woocommerce_checkout_order_review'); ?>
						</div>
					</section>

					<!-- Shipping Section -->
					<section class="section-checkout-shipping">
						<h2 class="section-title uk-margin-remove-bottom"><?php esc_html_e('Kargo', 'leanfit'); ?></h2>
						<div class="uk-card uk-card-small uk-border-0">
							<div class="uk-card-body uk-padding-remove">
								<?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>
									<?php do_action('woocommerce_review_order_before_shipping'); ?>
									<?php 
										$packages = WC()->shipping()->get_packages();
										if (!empty($packages)) {
											foreach ($packages as $i => $package) {
												$available_methods = $package['rates'];
												if (!empty($available_methods)) {
													foreach ($available_methods as $method) {
														$method_id = $method->get_id();
														$method_title = $method->get_label();
														$method_cost = $method->get_cost();
														$shipping_logo = '';
														
														// Kargo firmasına göre logo belirleme
														if (strpos(strtolower($method_title), 'yurtiçi') !== false) {
															$shipping_logo = get_template_directory_uri() . '/assets/image/yurtici.jpg';
														} else {
															$shipping_logo = get_template_directory_uri() . '/assets/image/placeholder.png';
														}
														// Diğer kargo firmaları için logo eklenebilir
														?>
														<div class="uk-flex uk-flex-middle">
															<input type="radio" 
																   name="shipping_method[<?php echo esc_attr($i); ?>]" 
																   id="shipping_method_<?php echo esc_attr($i); ?>_<?php echo esc_attr($method->get_id()); ?>" 
																   value="<?php echo esc_attr($method->get_id()); ?>" 
																   class="uk-hidden shipping-method" 
																   data-index="<?php echo esc_attr($i); ?>"
																   <?php checked($method->get_id(), WC()->session->get('chosen_shipping_methods')[$i] ?? ''); ?> />
															<label for="shipping_method_<?php echo esc_attr($i); ?>_<?php echo esc_attr($method->get_id()); ?>">
																<?php if ($shipping_logo) : ?>
																	<img src="<?php echo esc_url($shipping_logo); ?>" width="48" height="48" alt="<?php echo esc_attr($method_title); ?>" class="uk-margin-medium-right <?php echo checked($method->get_id(), WC()->session->get('chosen_shipping_methods')[$i] ?? '', false) ? 'uk-border-1' : ''; ?>">
																<?php endif; ?>
															</label>
															<label class="uk-flex uk-flex-middle" for="shipping_method_<?php echo esc_attr($i); ?>_<?php echo esc_attr($method->get_id()); ?>">
																<strong class="uk-margin-medium-right"><?php echo esc_html($method_title); ?></strong>
																<?php 
																$available_methods = WC()->shipping()->get_packages()[0]['rates'] ?? [];
																if (count($available_methods) === 1) : ?>
																	<span><?php esc_html_e('Standart Kargo', 'leanfit'); ?></span>
																<?php endif; ?>
																<?php /*if ($method_cost > 0) : ?>
																	<span class="uk-margin-small-left">(<?php echo wc_price($method_cost); ?>)</span>
																<?php endif; */ ?>
															</label>
														</div>
														<?php
													}
												}
											}
										}
									?>
									<?php do_action('woocommerce_review_order_after_shipping'); ?>
								<?php endif; ?>
							</div>
						</div>
					</section>

					<!-- Address Section -->
					<?php if ($checkout->get_checkout_fields()) : ?>
						<section class="section-checkout-address">
							<?php do_action('woocommerce_checkout_before_customer_details'); ?>
							<div id="customer_details">

								<!-- Seçili teslimat adresi görüntüleme -->
								<div class="uk-border-0 uk-margin">
									<div class="uk-card-body uk-padding-remove">
										<div class="address-info">
											<div class="uk-grid uk-child-width-1-1 uk-row-gap-20">
												<div>
													<div class="uk-grid uk-flex-between">
														<div>
															<h3><?php esc_html_e('Teslimat Adresi', 'leanfit'); ?></h3>
														</div>
														<div>
															<div class="uk-grid uk-grid-medium">
																<?php if ($selected_shipping_address) : ?>
																	<div>
																		<button type="button" class="button-text" uk-toggle="target: #detail-<?php echo esc_attr($selected_shipping_address->id); ?>">
																			<?php esc_html_e('Düzenle', 'leanfit'); ?>
																		</button>
																	</div>
																<?php endif; ?>
																<div>
																	<button type="button" class="button-text" uk-toggle="target: #shipping-address">
																		<?php esc_html_e('Değiştir', 'leanfit'); ?>
																	</button>
																</div>
															</div>
														</div>
													</div>
												</div>

												<?php if ($selected_shipping_address) : ?>
													<div>
														<p>
															<?php if (!empty($selected_shipping_address->address_title)) : ?>
																<?php echo esc_html($selected_shipping_address->address_title); ?>,<br>
															<?php endif; ?>
															<?php echo esc_html($selected_shipping_address->first_name . ' ' . $selected_shipping_address->last_name); ?>
														</p>
													</div>
													<div>
														<p>
															<?php echo esc_html($selected_shipping_address->address_1); ?><br>
															<?php 
																$address_parts = array();
																if (!empty($selected_shipping_address->neighborhood_name)) {
																	$address_parts[] = $selected_shipping_address->neighborhood_name;
																}
																if (!empty($selected_shipping_address->district_name)) {
																	$address_parts[] = $selected_shipping_address->district_name;
																}
																if (!empty($selected_shipping_address->city_name)) {
																	$address_parts[] = $selected_shipping_address->city_name;
																}
																echo esc_html(implode(' / ', $address_parts));
															?>
														</p>
													</div>
												<?php else : ?>
													<div>
														<p><?php esc_html_e('Henüz teslimat adresi seçilmedi.', 'leanfit'); ?></p>
													</div>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>

								<!-- Seçili fatura adresi görüntüleme -->
								<div class="uk-border-0">
									<div class="uk-card-body uk-padding-remove">
										<div class="address-info">
											<div class="uk-grid uk-child-width-1-1 uk-row-gap-20">
												<div>
													<div class="uk-grid uk-flex-between">
														<div>
															<h3><?php esc_html_e('Fatura Adresi', 'leanfit'); ?></h3>
														</div>
														<div>
															<div class="uk-grid uk-grid-medium">
																<?php if ($selected_billing_address) : ?>
																	<div>
																		<button type="button" class="button-text" uk-toggle="target: #detail-<?php echo esc_attr($selected_billing_address->id); ?>">
																			<?php esc_html_e('Düzenle', 'leanfit'); ?>
																		</button>
																	</div>
																<?php endif; ?>
																<div>
																	<button type="button" class="button-text" uk-toggle="target: #billing-address">
																		<?php esc_html_e('Değiştir', 'leanfit'); ?>
																	</button>
																</div>
															</div>
														</div>
													</div>
												</div>

												<?php if ($selected_billing_address) : ?>
													<div>
														<p>
															<?php if (!empty($selected_billing_address->address_title)) : ?>
																<?php echo esc_html($selected_billing_address->address_title); ?>,<br>
															<?php endif; ?>
															<?php echo esc_html($selected_billing_address->first_name . ' ' . $selected_billing_address->last_name); ?>
														</p>
													</div>
													<div>
														<p>
															<?php echo esc_html($selected_billing_address->address_1); ?><br>
															<?php 
																$address_parts = array();
																if (!empty($selected_billing_address->neighborhood_name)) {
																	$address_parts[] = $selected_billing_address->neighborhood_name;
																}
																if (!empty($selected_billing_address->district_name)) {
																	$address_parts[] = $selected_billing_address->district_name;
																}
																if (!empty($selected_billing_address->city_name)) {
																	$address_parts[] = $selected_billing_address->city_name;
																}
																echo esc_html(implode(' / ', $address_parts));
															?>
														</p>
													</div>
												<?php else : ?>
													<div>
														<p><?php esc_html_e('Henüz fatura adresi seçilmedi.', 'leanfit'); ?></p>
													</div>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>
							</div>

							<div class="uk-width-3-11@xxl uk-width-3-11@xl uk-width-4-11@l uk-width-4-11@m uk-width-1-1@s uk-margin-medium-top">
								<a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>" class="uk-button lean-button-dark uk-width-1-1 uk-text-uppercase"><?php esc_html_e('Yeni Adres Ekle', 'leanfit'); ?></a>
							</div>
							<?php do_action('woocommerce_checkout_after_customer_details'); ?>
						</section>
					<?php endif; ?>
				</div>

				<!-- Summary Section -->
				<div class="uk-width-3-11@l">
					<section class="section-checkout-summary">
						<div class="uk-border-0">
							<div class="uk-card-body uk-padding-remove">
								<h2 class="section-title uk-margin-remove uk-visible@m"><?php esc_html_e('Özet', 'leanfit'); ?></h2>

								<!-- Coupon Section -->
								<div class="section-checkout-coupon">
									<?php // do_action( 'woocommerce_before_checkout_form', $checkout ); ?>
									<?php if (wc_coupons_enabled()) : ?>
										<div class="coupon-input">
											<div class="uk-flex uk-flex-between uk-inline uk-width-1-1 align-items-center">
												<input type="text" name="coupon_code" class="uk-input" id="checkout-input-coupon" value="" placeholder="<?php esc_html_e('Kupon Kodu Kullan', 'leanfit'); ?>" />
												<button type="button" class="uk-button add-button" name="apply_coupon" id="checkout-add-coupon">
													<span uk-icon="icon: icn-plus"></span>
												</button>
											</div>
											<div id="coupon-message-container"></div>
										</div>
										<?php wp_nonce_field('apply-coupon', 'apply-coupon-nonce'); ?>
										<?php 
											$coupons = WC()->cart->get_coupons();
											if (!empty($coupons)) :
											?>
										<div class="coupon-list">
											<?php 
												foreach ($coupons as $code => $coupon) :
											?>
												<div class="coupon-item" id="coupon-<?php echo esc_attr(sanitize_title($code)); ?>">
													<div class="uk-flex uk-flex-between uk-grid-small">
														<div class="coupon-text"><?php echo esc_html($code); ?></div>
														<div class="coupon-cancel">
															<a href="javascript:void(0)" class="remove-coupon" data-coupon="<?php echo esc_attr($code); ?>">
																<span uk-icon="icon: icn-close"></span>
															</a>
														</div>
													</div>
												</div>
											<?php 
												endforeach;?>
										</div>
										<?php endif; ?>
									<?php endif; ?>
								</div>

								<!-- Order Summary -->
								<div class="uk-margin-small-top uk-margin-medium-bottom summary-details uk-visible@m">
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span><?php esc_html_e('Toplam Tutar', 'leanfit'); ?></span>
										<span><?php wc_cart_totals_subtotal_html(); ?></span>
									</div>

									<?php if (WC()->cart->needs_shipping()) : ?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span><?php esc_html_e('Kargo', 'leanfit'); ?></span>
										<?php if (WC()->cart->get_shipping_total() > 0) : ?>
											<span><?php echo wc_price(WC()->cart->get_shipping_total()); ?></span>
										<?php else : ?>
											<span><?php esc_html_e('Ücretsiz', 'leanfit'); ?></span>
										<?php endif; ?>
									</div>
									<?php endif; ?>
									
									<?php if (WC()->cart->get_coupons()) : ?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom uk-text-danger">
										<span class="lean-text-red"><?php esc_html_e('Kupon', 'leanfit'); ?></span>
										<span class="lean-text-red">-<?php 
											$discount_amount = 0;
											foreach (WC()->cart->get_coupons() as $code => $coupon) {
												$discount_amount += WC()->cart->get_coupon_discount_amount($code);
											}
											echo wc_price($discount_amount);
										?></span>
									</div>
									<?php endif; ?>
									
									<?php 
									// İndirim oranını hesapla
									$subtotal = WC()->cart->get_subtotal();
									$total = WC()->cart->get_total('edit');
									$shipping_total = WC()->cart->get_shipping_total();
									$total_without_shipping = $total - $shipping_total;
									$discount_percentage = 0;
									
									if ($subtotal > 0 && $total_without_shipping < $subtotal) {
										$discount_percentage = round((($subtotal - $total_without_shipping) / $subtotal) * 100);
									}
									
									if ($discount_percentage > 0) :
									?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span class="lean-text-red"><?php esc_html_e('İndirim', 'leanfit'); ?></span>
										<span class="lean-text-red">%<?php echo esc_html($discount_percentage); ?></span>
									</div>
									<?php endif; ?>
									
									<div class="uk-flex uk-flex-between checkout-total-price">
										<span><?php esc_html_e('Ödenecek Tutar', 'leanfit'); ?></span>
										<span><?php 
											ob_start();
											wc_cart_totals_order_total_html();
											$total_html = ob_get_clean();
											echo wp_strip_all_tags($total_html);
										?></span>
									</div>
								</div>

								<div class="uk-margin uk-visible@m">
									<label class="uk-form-label uk-flex align-items-center">
										<div>
											<input class="uk-checkbox terms" type="checkbox" id="terms" name="terms" <?php checked(isset($_POST['terms']), true); ?> required>
											<input type="hidden" name="terms-field" value="1">
										</div>
										<span class="uk-text-small uk-margin-small-left">

										<?php 
										printf(
											esc_html__('Kişisel Verilerin Korunması ve İşlenmesine İlişkin %1$s Bilgilendirme Metnini %2$s okudum ve kabul ettim.', 'leanfit'),
											'<a class="uk-text-red" href="#terms-modal" uk-toggle>',
											'</a>'
										); 
										?>
										</span>
									</label>
								</div>

								<!-- Terms Modal -->
								<div id="terms-modal" class="uk-modal-container" uk-modal>
									<div class="uk-modal-dialog">
										<button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
										<div class="uk-padding-large">
											<h2><?php 
												$privacy_page_id = get_option('wp_page_for_privacy_policy');
												$privacy_page = get_post($privacy_page_id);
												echo esc_html($privacy_page ? $privacy_page->post_title : _e('Information Text on the Protection and Processing of Personal Data', 'leanfit')); 
											?></h2>
											<div class="uk-margin-medium-top">
												<?php 
													if ($privacy_page_id) {
														echo apply_filters('the_content', $privacy_page->post_content);
													}
												?>
											</div>
										</div>
									</div>
								</div>

								<div class="uk-visible@m">
									<button type="submit" class="uk-button lean-button-red uk-width-1-1 continue-btn uk-text-uppercase" name="woocommerce_checkout_place_order" id="place_order" value="<?php esc_html_e('Devam Et', 'leanfit'); ?>" data-value="<?php esc_html_e('Devam Et', 'leanfit'); ?>"><?php esc_html_e('Devam Et', 'leanfit'); ?></button>
								</div>
								<!-- End Order Summary -->
							</div>
						</div>
					</section>
				</div>
			</div>
		</div>


		<section class="section-checkout-summary summary-mobile uk-hidden@m">
			<div class="uk-text-center uk-padding-small-bottom">
				<button type="button" class="uk-button uk-button-text summary-arrow" id="summary-arrow">
					<span uk-icon="icon: icn-summary-arrow"></span>
				</button>
			</div>

			<div class="uk-margin-small-top uk-margin-medium-bottom summary-details uk-hidden" id="mobile-summary-details">
				<div class="uk-flex uk-flex-between uk-margin-small-bottom">
					<span><?php esc_html_e('Toplam Tutar', 'leanfit'); ?></span>
					<span><?php wc_cart_totals_subtotal_html(); ?></span>
				</div>

				<?php if (WC()->cart->needs_shipping() && WC()->cart->get_shipping_total() > 0) : ?>
				<div class="uk-flex uk-flex-between uk-margin-small-bottom">
					<span><?php esc_html_e('Kargo', 'leanfit'); ?></span>
					<span><?php echo wc_price(WC()->cart->get_shipping_total()); ?></span>
				</div>
				<?php endif; ?>

				<?php if (WC()->cart->get_coupons()) : ?>
				<div class="uk-flex uk-flex-between uk-margin-small-bottom uk-text-danger">
					<span class="lean-text-red"><?php esc_html_e('Kupon', 'leanfit'); ?></span>
					<span class="lean-text-red">-<?php 
						$discount_amount = 0;
						foreach (WC()->cart->get_coupons() as $code => $coupon) {
							$discount_amount += WC()->cart->get_coupon_discount_amount($code);
						}
						echo wc_price($discount_amount);
					?></span>
				</div>
				<?php endif; ?>
	
				<?php 
				// İndirim oranını hesapla
				$subtotal = WC()->cart->get_subtotal();
				$total = WC()->cart->get_total('edit');
				$shipping_total = WC()->cart->get_shipping_total();
				$total_without_shipping = $total - $shipping_total;
				$discount_percentage = 0;
				
				if ($subtotal > 0 && $total_without_shipping < $subtotal) {
					$discount_percentage = round((($subtotal - $total_without_shipping) / $subtotal) * 100);
				}
				
				if ($discount_percentage > 0) :
				?>
				<div class="uk-flex uk-flex-between uk-margin-small-bottom">
					<span class="lean-text-red"><?php esc_html_e('İndirim', 'leanfit'); ?></span>
					<span class="lean-text-red">%<?php echo esc_html($discount_percentage); ?></span>
				</div>
				<?php endif; ?>
				<hr>
			</div>

			<div class="uk-padding-24 uk-padding-remove-top">
				<label class="uk-form-label uk-flex align-items-center">
					<div>
						<input class="uk-checkbox terms" type="checkbox" id="terms-mobile" name="terms" <?php checked(isset($_POST['terms']), true); ?> required>
						<input type="hidden" name="terms-field" value="1">
					</div>
					<span class="uk-text-small uk-margin-small-left">
						<?php 
						printf(
							esc_html__('Kişisel Verilerin Korunması ve İşlenmesine İlişkin %1$s Bilgilendirme Metnini %2$s okudum ve kabul ettim.', 'leanfit'),
							'<a href="#terms-modal" uk-toggle>',
							'</a>'
						);
						?>
					</span>
				</label>
			</div>

			<div class="uk-padding-24 uk-padding-remove-top uk-grid uk-grid-xsmall uk-flex-between align-items-center uk-child-width-1-2">
				<div class="checkout-total-price">
					<span><?php esc_html_e('Ödenecek Tutar', 'leanfit'); ?></span>
					<span><?php 
						ob_start();
						wc_cart_totals_order_total_html();
						$total_html = ob_get_clean();
						echo wp_strip_all_tags($total_html);
					?></span>
				</div>
				<div>
					<button type="submit" class="uk-button lean-button-red uk-width-1-1 continue-btn" name="woocommerce_checkout_place_order" id="place_order_mobile" value="<?php esc_html_e('Devam Et', 'leanfit'); ?>" data-value="<?php esc_html_e('Devam Et', 'leanfit'); ?>"><?php esc_html_e('Devam Et', 'leanfit'); ?></button>
				</div>
			</div>
		</section>
		
	</section>
</form>


<script>
    document.addEventListener("DOMContentLoaded", function () {
        const summaryButton = document.getElementById("summary-arrow");
        const summaryDetails = document.getElementById("mobile-summary-details");
        const icon = summaryButton.querySelector("span[uk-icon]");

        summaryButton.addEventListener("click", function () {
            summaryDetails.classList.toggle("uk-hidden");
            icon.style.transform = summaryDetails.classList.contains("uk-hidden") ? "rotate(0deg)" : "rotate(180deg)";
        });

        // Kupon input kontrolü
        document.getElementById("checkout-input-coupon").addEventListener("keyup", function () {
            document.getElementById("checkout-add-coupon").style.opacity = this.value !== "" ? "1" : "0";
        });

        // Miktar güncelleme işlemleri
        document.querySelectorAll(".quantity-buttons").forEach((container) => {
            const minusBtn = container.querySelector(".minus");
            const plusBtn = container.querySelector(".plus");
            const qtyInput = container.querySelector(".qty-value");
            const productId = container.getAttribute('data-id');
            const cartKey = container.getAttribute('data-cart-key');

            function updateQuantity(newQty) {
                if (newQty >= 1) {
                    container.style.opacity = '0.5';

					
					if (productId > 0) {
						jQuery.ajax({
							url: ajaxurl,
							type: 'POST',
							data: {
								action: 'update_cart_item_quantity',
								product_id: productId,
								quantity: newQty
							},
							success: function(response) {
								console.log(response);
								if(response.success) {
									window.location.reload();
								}
							}
						});
					}

                    
                    /*jQuery.ajax({
                        url: wc_checkout_params.wc_ajax_url.toString().replace('%%endpoint%%', 'update_order_review'),
                        type: 'POST',
                        data: {
                            security: wc_checkout_params.update_order_review_nonce,
                            cart_item_key: cartKey,
                            quantity: newQty
                        },
                        success: function(response) {
                            window.location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.error('Quantity update error:', error);
                            container.style.opacity = '1';
                        }
                    });*/
                }
            }

            minusBtn.addEventListener("click", () => {
                const currentValue = parseInt(qtyInput.value);
                if (currentValue > 1) {
                    updateQuantity(currentValue - 1);
                }
            });

            plusBtn.addEventListener("click", () => {
                const currentValue = parseInt(qtyInput.value);
                updateQuantity(currentValue + 1);
            });
        });

        // Terms Checkbox
        const termsCheckbox = document.querySelector(".terms");
        const continueBtn = document.querySelector(".continue-btn");

        if (termsCheckbox && continueBtn) {
            termsCheckbox.addEventListener("change", () => {
                continueBtn.disabled = !termsCheckbox.checked;
                continueBtn.style.opacity = termsCheckbox.checked ? "1" : "0.5";
            });
            continueBtn.disabled = !termsCheckbox.checked;
            continueBtn.style.opacity = termsCheckbox.checked ? "1" : "0.5";
        }
    });
</script>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>

<?php if ($checkout->get_checkout_fields()) : ?>
	<!-- Adres Değiştirme Modalı -->
	<div id="billing-address" class="checkout-modal" uk-modal>
		<div class="uk-modal-dialog uk-modal-body" uk-overflow-auto>
			<div class="lean-modal-header">
				<div class="uk-grid uk-flex-between align-items-center">
					<div>
						<h2 class="uk-modal-title uk-margin-remove"><?php esc_html_e('Fatura Adresini Düzenle', 'leanfit'); ?></h2>
					</div>
					<div>
						<button class="uk-modal-close" type="button"><span uk-icon="icon: icn-close"></span></button>
					</div>
				</div>
			</div>

			<div class="uk-modal-content">
				<div class="address-items">
					<?php foreach ($billing_addresses as $address) : ?>
						<div class="address-item uk-width-1-1@s">
							<div class="address-info uk-margin<?php echo $address->is_selected ? ' address-selected' : ''; ?>">
								<div class="uk-grid uk-child-width-1-1 uk-row-gap-20">
									<?php if ($address->is_selected) : ?>
										<div>
											<div>
												<h3><?php esc_html_e('Kullanılan Adres', 'leanfit'); ?></h3>
											</div>
										</div>
									<?php endif; ?>
									<div>
										<p>
											<?php if (!empty($address->address_title)) : ?>
												<?php echo esc_html($address->address_title); ?>,<br>
											<?php endif; ?>
											<?php echo esc_html($address->first_name . ' ' . $address->last_name); ?>
										</p>
									</div>
									<div>
										<p>
											<?php echo esc_html($address->address_1); ?><br>
											<?php 
												$address_parts = array();
												if (!empty($address->neighborhood_name)) {
													$address_parts[] = $address->neighborhood_name;
												}
												if (!empty($address->district_name)) {
													$address_parts[] = $address->district_name;
												}
												if (!empty($address->city_name)) {
													$address_parts[] = $address->city_name;
												}
												echo esc_html(implode(' / ', $address_parts));
											?>
										</p>
									</div>
									<?php if (!$address->is_selected) : ?>
										<div class="uk-width-9-11@m">
											<button type="button" class="uk-button lean-button-dark select-address" 
													data-address-id="<?php echo esc_attr($address->id); ?>" 
													data-address-type="billing">
												<?php esc_html_e('Fatura Adresini Seç', 'leanfit'); ?>
											</button>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</div>

	<!-- Adres Düzenleme Modalları -->
	<?php foreach ($billing_addresses as $address) : ?>
		<div class="address-edit checkout-modal" id="detail-<?php echo esc_attr($address->id); ?>" uk-modal>
		<div class="uk-modal-dialog uk-modal-body" uk-overflow-auto>
			<div class="lean-modal-header">
				<div class="uk-grid uk-flex-between align-items-center">
					<div>
						<h2 class="uk-modal-title uk-margin-remove"><?php esc_html_e('Fatura Adresini Düzenle', 'leanfit'); ?></h2>
					</div>
					<div>
						<button class="uk-modal-close" type="button"><span uk-icon="icon: icn-close"></span></button>
					</div>
				</div>
			</div>

			<div class="uk-modal-content">
				<form action="" method="post" class="lean-form edit-address-form" data-address-type="billing" data-address-id="<?php echo esc_attr($address->id); ?>">
					<?php wp_nonce_field('woocommerce-edit_address', 'woocommerce-edit-address-nonce'); ?>
					<input type="hidden" name="action" value="edit_address" />
					<input type="hidden" name="address_id" value="<?php echo esc_attr($address->id); ?>" />
					<input type="hidden" name="address_type" value="billing" />

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="address_title" value="<?php echo esc_attr($address->address_title); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Adres Başlığı', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="first_name" value="<?php echo esc_attr($address->first_name); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Ad', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="last_name" value="<?php echo esc_attr($address->last_name); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Soyadı', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="company" value="<?php echo esc_attr($address->company); ?>" placeholder=" " aria-label="Input">
						<label><?php esc_html_e('Şirket Adı (İsteğe Bağlı)', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="country" value="Türkiye" placeholder=" " aria-label="Input" readonly>
						<label><?php esc_html_e('Ülke', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<select class="uk-select" name="city" data-selected="<?php echo esc_attr($address->city_id); ?>" id="billing_city_<?php echo esc_attr($address->id); ?>" required>
							<option value=""><?php esc_html_e('Select a city', 'woocommerce'); ?></option>
						</select>
						<label><?php esc_html_e('Şehir', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<select class="uk-select" name="district" data-selected="<?php echo esc_attr($address->district_id); ?>" id="billing_district_<?php echo esc_attr($address->id); ?>" required>
							<option value=""><?php esc_html_e('Select a district', 'woocommerce'); ?></option>
						</select>
						<label><?php esc_html_e('İlçe', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<select class="uk-select" name="neighborhood" data-selected="<?php echo esc_attr($address->neighborhood_id); ?>" id="billing_neighborhood_<?php echo esc_attr($address->id); ?>" required>
							<option value=""><?php esc_html_e('Select a neighborhood', 'woocommerce'); ?></option>
						</select>
						<label><?php esc_html_e('Mahalle', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="address_1" value="<?php echo esc_attr($address->address_1); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Sokak Adresi', 'leanfit'); ?></label>
					</div>

					<div class="uk-text-center uk-section-small">
						<button type="submit" class="uk-button save-button uk-width-1-1@s uk-text-uppercase"><?php esc_html_e('Adresi Kaydet', 'leanfit'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
	<?php endforeach; ?>

	<!-- Teslimat Adresi Değiştirme Modalı -->
	<div id="shipping-address" class="checkout-modal" uk-modal>
		<div class="uk-modal-dialog uk-modal-body" uk-overflow-auto>
			<div class="lean-modal-header">
				<div class="uk-grid uk-flex-between align-items-center">
					<div>
						<h2 class="uk-modal-title uk-margin-remove"><?php esc_html_e('Teslimat Adresini Düzenle', 'leanfit'); ?></h2>
					</div>
					<div>
						<button class="uk-modal-close" type="button"><span uk-icon="icon: icn-close"></span></button>
					</div>
				</div>
			</div>

			<div class="uk-modal-content">
				<div class="address-items">
					<?php foreach ($shipping_addresses as $address) : ?>
						<div class="address-item uk-width-1-1@s">
							<div class="address-info uk-margin<?php echo $address->is_selected ? ' address-selected' : ''; ?>">
								<div class="uk-grid uk-child-width-1-1 uk-row-gap-20">
									<?php if ($address->is_selected) : ?>
										<div>
											<div>
												<h3><?php esc_html_e('Kullanılan Adres', 'leanfit'); ?></h3>
											</div>
										</div>
									<?php endif; ?>
									<div>
										<p>
											<?php if (!empty($address->address_title)) : ?>
												<?php echo esc_html($address->address_title); ?>,<br>
											<?php endif; ?>
											<?php echo esc_html($address->first_name . ' ' . $address->last_name); ?>
										</p>
									</div>
									<div>
										<p>
											<?php echo esc_html($address->address_1); ?><br>
											<?php 
												$address_parts = array();
												if (!empty($address->neighborhood_name)) {
													$address_parts[] = $address->neighborhood_name;
												}
												if (!empty($address->district_name)) {
													$address_parts[] = $address->district_name;
												}
												if (!empty($address->city_name)) {
													$address_parts[] = $address->city_name;
												}
												echo esc_html(implode(' / ', $address_parts));
											?>
										</p>
									</div>
									<?php if (!$address->is_selected) : ?>
										<div class="uk-width-9-11@m">
											<button type="button" class="uk-button lean-button-dark select-address" 
													data-address-id="<?php echo esc_attr($address->id); ?>" 
													data-address-type="shipping">
												<?php esc_html_e('Teslimat Adresini Seç', 'leanfit'); ?>
											</button>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</div>

	<!-- Teslimat Adresi Düzenleme Modalları -->
	<?php foreach ($shipping_addresses as $address) : ?>
		<div class="address-edit checkout-modal" id="detail-<?php echo esc_attr($address->id); ?>" uk-modal>
		<div class="uk-modal-dialog uk-modal-body" uk-overflow-auto>
			<div class="lean-modal-header">
				<div class="uk-grid uk-flex-between align-items-center">
					<div>
						<h2 class="uk-modal-title uk-margin-remove"><?php esc_html_e('Teslimat Adresini Düzenle', 'leanfit'); ?></h2>
					</div>
					<div>
						<button class="uk-modal-close" type="button"><span uk-icon="icon: icn-close"></span></button>
					</div>
				</div>
			</div>

			<div class="uk-modal-content">
				<form action="" method="post" class="lean-form edit-address-form" data-address-type="shipping" data-address-id="<?php echo esc_attr($address->id); ?>">
					<?php wp_nonce_field('woocommerce-edit_address', 'woocommerce-edit-address-nonce'); ?>
					<input type="hidden" name="action" value="edit_address" />
					<input type="hidden" name="address_id" value="<?php echo esc_attr($address->id); ?>" />
					<input type="hidden" name="address_type" value="shipping" />

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="address_title" value="<?php echo esc_attr($address->address_title); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Adres Başlığı', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="first_name" value="<?php echo esc_attr($address->first_name); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Ad', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="last_name" value="<?php echo esc_attr($address->last_name); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Soyadı', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="company" value="<?php echo esc_attr($address->company); ?>" placeholder=" " aria-label="Input">
						<label><?php esc_html_e('Şirket Adı (İsteğe Bağlı)', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="country" value="Türkiye" placeholder=" " aria-label="Input" readonly>
						<label><?php esc_html_e('Ülke', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<select class="uk-select" name="city" data-selected="<?php echo esc_attr($address->city_id); ?>" id="shipping_city_<?php echo esc_attr($address->id); ?>" required>
							<option value=""><?php esc_html_e('Select a city', 'woocommerce'); ?></option>
						</select>
						<label><?php esc_html_e('Şehir', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<select class="uk-select" name="district" data-selected="<?php echo esc_attr($address->district_id); ?>" id="shipping_district_<?php echo esc_attr($address->id); ?>" required>
							<option value=""><?php esc_html_e('Select a district', 'woocommerce'); ?></option>
						</select>
						<label><?php esc_html_e('İlçe', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<select class="uk-select" name="neighborhood" data-selected="<?php echo esc_attr($address->neighborhood_id); ?>" id="shipping_neighborhood_<?php echo esc_attr($address->id); ?>" required>
							<option value=""><?php esc_html_e('Select a neighborhood', 'woocommerce'); ?></option>
						</select>
						<label><?php esc_html_e('Mahalle', 'leanfit'); ?></label>
					</div>

					<div class="uk-margin form-floating">
						<input class="uk-input" type="text" name="address_1" value="<?php echo esc_attr($address->address_1); ?>" placeholder=" " aria-label="Input" required>
						<label><?php esc_html_e('Cadde/Sokak', 'leanfit'); ?></label>
					</div>

					<div class="uk-text-center uk-section-small">
						<button type="submit" class="uk-button save-button uk-width-1-1@s uk-text-uppercase"><?php esc_html_e('Adresi Kaydet', 'leanfit'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
	<?php endforeach; ?>

	
<script>
jQuery(document).ready(function($) {
    // İlleri yükle ve seçili olanı işaretle
    function loadCities(selectElement, selectedCityId = null) {
        if (!selectElement) {
            console.error('Select element not found');
            return;
        }

        var $select = $(selectElement);
        
        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'get_cities',
                security: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
                    $select.find('option:not(:first)').remove();
                    
                    $.each(response.data, function(index, item) {
                        var $option = $('<option></option>')
                            .val(item.id)
                            .text(item.name);
                            
                        if (selectedCityId && selectedCityId == item.id) {
                            $option.prop('selected', true);
                        }
                        
                        $select.append($option);
                    });
                    
                    // Seçili şehir varsa ilçeleri yükle
                    if (selectedCityId) {
                        var $districtSelect = $select.closest('form').find('select[name="district"]');
                        loadDistricts($districtSelect[0], selectedCityId, $districtSelect.data('selected'));
                    }
                }
            }
        });
    }

    // İlçeleri yükle ve seçili olanı işaretle
    function loadDistricts(selectElement, cityId, selectedDistrictId = null) {
        if (!cityId) return;
        
        var $select = $(selectElement);
        
        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'get_districts',
                city_id: cityId,
                security: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
                    $select.find('option:not(:first)').remove();
                    $.each(response.data, function(index, item) {
                        var $option = $('<option></option>')
                            .val(item.id)
                            .text(item.name);
                            
                        if (selectedDistrictId && selectedDistrictId == item.id) {
                            $option.prop('selected', true);
                        }
                        
                        $select.append($option);
                    });
                    
                    // Seçili ilçe varsa semtleri yükle
                    if (selectedDistrictId) {
                        var $neighborhoodSelect = $select.closest('form').find('select[name="neighborhood"]');
                        loadNeighborhoods($neighborhoodSelect[0], selectedDistrictId, $neighborhoodSelect.data('selected'));
                    }
                }
            }
        });
    }

    // Semtleri yükle ve seçili olanı işaretle
    function loadNeighborhoods(selectElement, districtId, selectedNeighborhoodId = null) {
        if (!districtId) return;
        
        var $select = $(selectElement);
        
        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'get_neighborhoods',
                district_id: districtId,
                security: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
                    $select.find('option:not(:first)').remove();
                    $.each(response.data, function(index, item) {
                        var $option = $('<option></option>')
                            .val(item.id)
                            .text(item.name);
                            
                        if (selectedNeighborhoodId && selectedNeighborhoodId == item.id) {
                            $option.prop('selected', true);
                        }
                        
                        $select.append($option);
                    });
                }
            }
        });
    }

    // İl değiştiğinde ilçeleri yükle
    $(document).on('change', 'select[name="city"]', function() {
        var cityId = $(this).val();
        var $form = $(this).closest('form');
        var $districtSelect = $form.find('select[name="district"]');
        var $neighborhoodSelect = $form.find('select[name="neighborhood"]');
        
        if (cityId) {
            loadDistricts($districtSelect[0], cityId);
            $neighborhoodSelect.find('option:not(:first)').remove();
        }
    });

    // İlçe değiştiğinde semtleri yükle
    $(document).on('change', 'select[name="district"]', function() {
        var districtId = $(this).val();
        var $form = $(this).closest('form');
        var $neighborhoodSelect = $form.find('select[name="neighborhood"]');
        
        if (districtId) {
            loadNeighborhoods($neighborhoodSelect[0], districtId);
        }
    });

    // UIkit modal event listener
    UIkit.util.on('.address-edit', 'shown', function () {
        var modal = this;
        var $form = $(modal).find('form');
        var $citySelect = $form.find('select[name="city"]');
        var selectedCityId = $citySelect.data('selected');
        
        // İlleri yükle
        loadCities($citySelect[0], selectedCityId);
    });

	// Adres düzenleme formu gönderimi
	$('.edit-address-form').on('submit', function(e) {
		e.preventDefault();
		var $form = $(this);
		var formData = $form.serialize();
		
		console.log('Form data:', formData); // Debug log
		
		$.ajax({
			url: wc_add_to_cart_params.ajax_url,
			type: 'POST',
			data: formData,
			beforeSend: function() {
				$form.find('button[type="submit"]').prop('disabled', true);
			},
			success: function(response) {	
				if (response.success) {
					location.reload();
				} else {
					alert(response.data.message || '<?php esc_html_e('Adres güncellenirken bir hata oluştu', 'leanfit'); ?>');
				}
			},
			error: function(xhr, status, error) {
				console.error('AJAX error:', {xhr: xhr, status: status, error: error}); // Debug log
				alert('<?php esc_html_e('Adres güncellenirken bir hata oluştu', 'leanfit'); ?>');
			},
			complete: function() {
				$form.find('button[type="submit"]').prop('disabled', false);
			}
		});
	});

    // Adres seçme butonu tıklama olayı
    $(document).on('click', '.select-address', function(e) {
        e.preventDefault();
        var $button = $(this);
        var addressId = $button.data('address-id');
        var addressType = $button.data('address-type');
        
        // Butonu devre dışı bırak ve yükleniyor göster
        $button.prop('disabled', true);
        
        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'update_selected_address',
                address_id: addressId,
                address_type: addressType,
                security: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
					window.location.reload();
                } else {
                    // Hata mesajını göster
                    alert(response.data.message || '<?php _e('Adres seçilirken bir hata oluştu.', 'leanfit'); ?>');
                    // Butonu tekrar aktif et
                    $button.prop('disabled', false);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', {xhr: xhr, status: status, error: error});
                alert('<?php esc_html_e('Adres seçilirken bir hata oluştu.', 'leanfit'); ?>');
                // Butonu tekrar aktif et
                $button.prop('disabled', false);
            }
        });
    });

    // Kargo metodu değiştiğinde AJAX ile güncelle
    $(document).on('change', 'input.shipping-method', function() {
        var $input = $(this);
        var method = $input.val();
        var index = $input.data('index');

        $.ajax({
            url: wc_checkout_params.wc_ajax_url.toString().replace('%%endpoint%%', 'update_shipping_method'),
            type: 'POST',
            data: {
                shipping_method: {
                    [index]: method
                },
                security: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                window.location.reload();
            },
            error: function(xhr, status, error) {
                console.error('Kargo metodu güncellenirken bir hata oluştu:', error);
                window.location.reload();
            }
        });
    });
});
</script>

<?php endif; ?>