<?php

get_header();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Form verilerini al
    $name = sanitize_text_field($_POST['name']);
    $surname = sanitize_text_field($_POST['surname']);
    $email = sanitize_email($_POST['email']);
    $subject = sanitize_text_field($_POST['subject']);
    $enquiry = sanitize_textarea_field($_POST['enquiry']);

    // E-posta gönder
    $to = get_option('admin_email'); // E-posta adresi olarak admin e-posta adresini alıyoruz
    $headers = array('Content-Type: text/html; charset=UTF-8', 'From: ' . $email);
    $message = "
        <html>
        <head><title>İletişim Formu Gönderimi</title></head>
        <body>
            <h2>İletişim Formu Detayları</h2>
            <p><strong>Ad:</strong> $name $surname</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Konu:</strong> $subject</p>
            <p><strong>Mesaj:</strong> $enquiry</p>
        </body>
        </html>
    ";

    // wp_mail fonksiyonu ile e-posta gönder
    if (wp_mail($to, $subject, $message, $headers)) {
        echo '<p>Mesajınız için teşekkür ederiz. En kısa sürede size geri dönüş yapacağız.</p>';
    } else {
        echo '<p>Bir hata oluştu. Lütfen daha sonra tekrar deneyiniz.</p>';
    }
}
?>

<script>document.querySelector(".header-all").classList.add("header-relative");</script>

<main>
    <section class="contact-title">
        <div class="uk-container">
            <?php
            if ( have_posts() ) :
                while ( have_posts() ) :
                    the_post();
                    the_content();
                endwhile;
            endif;

            wp_reset_query();
            ?>
        </div>
    </section>

    <section class="contact-info-form">
        <div class="uk-container">
            <div class="uk-grid uk-grid-large uk-grid-match" uk-grid>
                <div class="uk-width-1-3@m">
                    <div class="contact-info">
                        <h2>İletişim Bilgileri</h2>

                        <p class="uk-margin-medium-bottom"><?= get_option('company_address');?></p>

                        <p class="email"><a href="mailto:<?= get_option('email_address');?>"><?= get_option('email_address');?></a></p>
                    </div>
                </div>

                <div class="uk-width-2-3@m">
                    <div class="contact-form">

                        <?= do_shortcode('[contact-form-7 id="8a6dde5" title="İletişim formu 1"]'); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="uk-container p-mobile-zero">
            <div class="uk-grid uk-margin-large-top uk-margin-large-bottom mb-mobile-zero" uk-grid>
            </div>
        </div>
    </section>
</main>

<?php
get_footer();
?>