<?php get_header(); ?>

<script>document.querySelector(".header-all").classList.add("header-relative");</script>

<?php if (have_posts()) : while (have_posts()) : the_post(); 
    $post_id = get_the_ID();
    $thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'full');
    $default_image = get_template_directory_uri() . '/assets/image/placeholder.png';
    $thumbnail = $thumbnail ? $thumbnail : $default_image;
    $categories = get_the_category();
?>

<div class="blog-detail">
    <div class="custom-container">
        <div class="border-bottom uk-margin-large-bottom">
            <div class="uk-grid-large uk-grid-gap-large uk-child-width-1-2@m" uk-grid>
                <div>
                    <img class="max-w-full blog-image" src="<?php echo esc_url($thumbnail); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
                </div>
                <div>
                    <div class="content">
                        <?php if($categories) : ?>
                            <span class="subtitle"><?php echo esc_html($categories[0]->name); ?></span>
                        <?php endif; ?>
                        
                        <h1><?php the_title(); ?></h1>
                        
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php
    // Benzer yazılar
    $related_posts = new WP_Query(array(
        'post_type' => 'post',
        'posts_per_page' => 2,
        'post__not_in' => array($post_id),
        'category__in' => wp_get_post_categories($post_id)
    ));

    if($related_posts->have_posts()) : ?>
    <div class="related-blogs">
        <div class="custom-container">
            <div class="uk-grid-large uk-grid-small uk-child-width-1-3@m uk-child-width-1-2@s uk-child-width-1-1" uk-grid>
                <div>
                    <h2 class="title"><?= __( 'Diğer hikayeleri okuyun ve ürünlerimizin nasıl fark yarattığını öğrenin.', 'leanfit' );?></h2>
                </div>
                
                <?php while($related_posts->have_posts()) : $related_posts->the_post();
                    $thumb = get_the_post_thumbnail_url(get_the_ID(), 'large');
                    $thumb = $thumb ? $thumb : $default_image;
                ?>
                <div>
                    <div class="uk-inline-clip uk-width-1-1 uk-transition-toggle" tabindex="0">
                        <a href="<?php the_permalink(); ?>">
                            <img
                                src="<?php echo esc_url($thumb); ?>"
                                srcset="<?php echo esc_url($thumb); ?>, <?php echo esc_url($thumb); ?> 767w"
                                class="uk-width-1-1 uk-transition-scale-up uk-transition-opaque"
                                alt="<?php echo esc_attr(get_the_title()); ?>"
                            />
                        </a>
                    </div>
                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    <span class="border-bottom"></span>
                </div>
                <?php endwhile; wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php
endwhile; endif;
?>

<?php get_footer(); ?> 