


<div class="uk-position-relative uk-section uk-section-large pb-mobile-zero uk-flex uk-flex-middle uk-height-viewport section-scroll-product-night">
    <div class="uk-width-1-1">

        <div class="uk-grid-margin uk-container">
            <div class="uk-grid tm-grid-expand uk-child-width-1-1">

                <div id="product-img-mobile" class="uk-hidden@s uk-position-relative uk-width-1-1 uk-text-center uk-margin-medium-bottom">
                    <picture>
                        <source id="day-image-mobile" srcset="<?= $block->image; ?>" sizes="(min-width: 400px) 400px" />
                        <img id="product-img-mobile" decoding="async" src="<?= $block->mobile_image; ?>" width="180" class="el-image" alt="Product" loading="lazy" />
                    </picture>

                    <div id="mode-switch-container-mobile" class="uk-position-relative" style="width: 100%;">
                        <div class="uk-flex uk-flex-center w-full uk-margin-top">
                            <div class="toggle-container">
                                <input type="checkbox" id="mode-switch-mobile" />
                                <label for="mode-switch-mobile" class="toggle-switch">
                                    <span class="toggle-handle">
                                        <span class="toggle-day"></span>
                                        <span class="toggle-night"></span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <article class="uk-width-1-2@m uk-width-1-1">
                    <h2 class="uk-heading-large uk-width-xlarge@m uk-position-relative uk-margin-top uk-width-1-1 uk-text-normal section-title" style="z-index: 3;">
                        <?= $block->title; ?>
                    </h2>
                    <div class="uk-panel uk-width-large@m uk-position-relative uk-margin uk-width-1-1 section-description" style="z-index: 3;"><?= $block->description; ?></div>


                    <div class="uk-position-relative uk-margin-medium" style="z-index: 3;">
                        <a class="el-content uk-button uk-button-primary" href="<?= $block->button_link; ?>">
                            <?= $block->button_text; ?>
                        </a>
                    </div>
                </article>

                <div id="product-img" class="uk-position-relative uk-width-1-2@m uk-text-center uk-visible@s">
                    <picture>
                        <source id="day-image" srcset="<?= $block->image; ?>" sizes="(min-width: 400px) 400px" />
                        <img id="product-img" decoding="async" src="<?= $block->mobile_image; ?>" width="350" class="el-image" alt="Product" loading="lazy" />
                    </picture>


                    <div id="mode-switch-container" class="uk-position-relative" style="width: 100%;">
                        <div class="uk-flex uk-flex-center w-full uk-margin-top">
                            <div class="toggle-container">
                                <input type="checkbox" id="mode-switch" />
                                <label for="mode-switch" class="toggle-switch">
                                    <span class="toggle-handle">
                                        <span class="toggle-day"></span>
                                        <span class="toggle-night"></span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <section class="nutrition-icons uk-margin-xlarge-top">
            <div class="custom-container">
                <div class="uk-grid uk-flex-center" uk-grid>
                
                    <div class="uk-width-2-3@m">
                        <div class="nutrition-icon-items uk-grid uk-child-width-1-6@m uk-child-width-1-3 uk-grid-small uk-grid-match">
                            <?php foreach ($data_array as $item) : ?>
                            <div>
                                <div class="nutrition-icon-item">
                                    <div class="uk-flex uk-flex-center uk-flex-wrap">
                                        <span uk-icon="<?= $item['banner_class']; ?>"></span>
                                        <h3><?= $item['text']; ?></h3>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
    </div>
</div>


<style>
    /* Gölge efekti için overlay */
    .overlay-product {
        position: absolute;
        /* top: 100%; */
        /* left: 0; */
        width: 450px;
        height: 41px;
        border-radius: 50%;
        z-index: 2;
        background: rgb(0, 0, 0);
        /*background: radial-gradient(circle, rgba(0, 0, 0, 1) 0%, rgba(255, 255, 255, 0) 100%);*/
        /* background: linear-gradient(0deg, rgba(0, 0, 0, 1) 0%, rgba(255, 255, 255, 0) 100%); */
        background: radial-gradient(#000000, #3b3b3b00, #00000000);
    }

    /* Görselin konumunu ayarlama */
    #product-image {
        position: relative; /* Gölgenin doğru konumlanabilmesi için */
        z-index: 1; /* Görseli üstte tutalım */
    }

    /* Toggle Switch Styles */
    .toggle-container {
        position: relative;
        width: 80px;
        height: 40px;
    }

    .toggle-switch {
        position: relative;
        display: block;
        width: 100%;
        height: 100%;
        background: #fff;
        border-radius: 40px;
        border: 2px solid #e8e8e8;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .toggle-handle {
        position: absolute;
        top: 2px;
        left: 2px;
        width: 32px;
        height: 32px;
        background: #fff;
        border-radius: 50%;
        transition: all 0.3s ease;
    }

    .toggle-day {
        position: absolute;
        top: 4px;
        left: 4px;
        width: 24px;
        height: 24px;
        background: #FFD700;
        border-radius: 50%;
        transition: all 0.3s ease;
    }

    .toggle-night {
        position: absolute;
        top: 4px;
        left: 4px;
        width: 24px;
        height: 24px;
        background: #152C70;
        border-radius: 50%;
        opacity: 0;
        transition: all 0.3s ease;
    }

    /* Switch aktif durumu */
    #mode-switch, #mode-switch-mobile {
        display: none;
    }

    #mode-switch:checked + .toggle-switch, #mode-switch-mobile:checked + .toggle-switch {
        background: #152C70;
    }

    #mode-switch:checked + .toggle-switch .toggle-handle, #mode-switch-mobile:checked + .toggle-switch .toggle-handle {
        transform: translateX(40px);
    }

    #mode-switch:checked + .toggle-switch .toggle-day, #mode-switch-mobile:checked + .toggle-switch .toggle-day {
        opacity: 0;
    }

    #mode-switch:checked + .toggle-switch .toggle-night, #mode-switch-mobile:checked + .toggle-switch .toggle-night {
        opacity: 1;
    }
</style>
<script>
    document.addEventListener("DOMContentLoaded", () => {
        // Switch kontrolü
        const modeSwitch = document.querySelector("#mode-switch");
        const productImg = document.querySelector("#product-img");
        const dayImageSource = document.querySelector("#day-image");

        const dayImage = "<?= $block->image; ?>";
        const nightImage = "<?= $block->mobile_image; ?>";

        modeSwitch.addEventListener("change", () => {
            const isNightMode = modeSwitch.checked;
            productImg.src = isNightMode ? nightImage : dayImage;
            dayImageSource.srcset = isNightMode ? nightImage : dayImage;
        });

        // Mobil switch kontrolü
        const mobileModeSwitch = document.querySelector("#mode-switch-mobile");
        const mobileImg = document.querySelector("#product-img-mobile");
        const mobileImageSource = document.querySelector("#day-image-mobile");
        
        if (mobileModeSwitch) {
            mobileModeSwitch.addEventListener("change", () => {
                const isNightMode = mobileModeSwitch.checked;
                mobileImg.src = isNightMode ? nightImage : dayImage;
                mobileImageSource.srcset = isNightMode ? nightImage : dayImage;
            });
        }
    });
</script>