
<?php

$product_ids = [];

foreach ($data_array as $item) {
    if (isset($item["selected_product"]) && $item["selected_product"])
        $product_ids[] = $item["selected_product"];
}

?>

<section class="featured-products uk-padding-remove uk-background-none">
    <div class="uk-container">
        <div class="uk-grid uk-flex-center" uk-grid>
            <div class="uk-width-9-11@m uk-margin-medium-bottom">
                <h2 class="section-title uk-text-center"><?= $block->title;?></h2>
            </div>
        </div>
    </div>

    <div class="custom-container">
        <div class="uk-grid-small uk-margin-xlarge-bottom uk-margin-medium-top" uk-grid>

            <?php
            foreach ($product_ids as $product_id) :
                // Her bir ürün ID'si için sorgu yapalım
                $args = array(
                    'post_type' => 'product',
                    'p' => $product_id,  // Tek bir ürün ID'sini sorgulamak için 'p' parametresini kullanıyoruz
                    'posts_per_page' => 1
                );
                $query = new WP_Query($args);

                if ($query->have_posts()) :
                    while ($query->have_posts()) : $query->the_post();
                        $category_name = "";
                        $terms = get_the_terms(get_the_ID(), 'product_cat');

                        if ($terms && !is_wp_error($terms)) {
                            foreach ($terms as $term) {
                                $category_name = $term->name;
                            }
                        }
                        global $product;
                        ?>
                        <div class="uk-width-1-2@s uk-width-1-1 img-w-50">
                            <div class="leanfit-product-layout product-item" data-item-id="<?php the_ID(); ?>" data-item-name="<?php the_title(); ?>" data-item-price="<?php echo get_post_meta(get_the_ID(), '_price', true); ?>" data-item-currency="TRY" data-item-category="<?= $category_name; ?>" data-item-brand="LeanFit by Game">
                                <div class="uk-position-relative uk-overflow-hidden">
                                    <div class="uk-text-uppercase uk-position-absolute uk-position-z-index-2 product-icon"><i uk-icon="icn-vegan-green"></i> <?php echo get_post_meta($product->get_id(), '_custom_badge', true); ?></div>
                                    <div class="uk-position-relative uk-position-z-index-zero product-image-box">
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" class="img-responsive" />
                                        </a>
                                    </div>
                                </div>

                                <div class="uk-position-relative product-details">
                                    <div class="uk-flex uk-flex-between uk-items-center">
                                        <div class="product-stars">
                                            <?php
                                            $average_rating = $product->get_average_rating();
                                            $comment_count = get_comments_number($product->get_id()); // Ürün için yorum sayısını alıyoruz
                                            $average_rating = $comment_count > 0 ? round($average_rating, 1) : 5; // Yorum yoksa 5 yıldız göster

                                            for ($i = 1; $i <= 5; $i++) {
                                                if ($i <= floor($average_rating)) {
                                                    echo '<span uk-icon="icn-star" class="star filled"></span>';
                                                } elseif ($i - 0.5 <= $average_rating) {
                                                    echo '<span uk-icon="icn-star-half" class="star half-filled"></span>';
                                                } else {
                                                    echo '<span uk-icon="icn-star-null" class="star"></span>';
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="product-gr"><?php echo get_post_meta($product->get_id(), '_custom_weight', true); ?></p>
                                    </div>

                                    <h3 class="product-name"><a href="<?php the_permalink(); ?>" class="text-decoration-none" tabindex="0"><?php the_title(); ?></a></h3>
                                    <p class="product-price">
                                        <span><?php echo price_format(get_post_meta(get_the_ID(), '_price', true)); ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                endif;
            endforeach;

            wp_reset_postdata();
            ?>


        </div>
    </div>
</section>