var checkout = {
    'count': {
        'init' : function (elem, position = "down", product_id = 0) {
            var total_count;
            var input_elem = $(elem).closest('.count-input').find('.product-quantity');
            total_count = parseInt($(input_elem).val()) - 1;

            if (position === "up") {
                total_count = parseInt($(input_elem).val()) + 1;
            }

            if (total_count && total_count > 0) {
                $(input_elem).val(total_count);
            }
        },

        'cart_init' : function (elem, position = "down", product_id = 0) {
            var total_count;
            var input_elem = $(elem).closest('.count-input').find('.product-quantity');
            total_count = parseInt($(input_elem).val()) - 1;

            if (position === "up") {
                total_count = parseInt($(input_elem).val()) + 1;
            }

            if (total_count && total_count > 0) {
                $(input_elem).val(total_count);

                if (product_id > 0) {
                    jQuery.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'update_cart_item_quantity',
                            product_id: product_id,
                            quantity: total_count
                        },
                        success: function(response) {
                            if(response.success) {
                                loadCartContents();
                            }
                        }
                    });
                }
            }
        }
    },

    coupons: {
        init: function() {
            if (document.getElementById('apply_coupon')) {
                document.getElementById('apply_coupon').addEventListener('click', this.applyCoupon);
            }
        },

        applyCoupon: function() {
            const couponCode = document.getElementById('coupon_code').value;
            const responseDiv = document.getElementById('coupon_response');

            if (!couponCode) {
                checkout.coupons.showMessage('Lütfen bir kupon kodu girin.', 'error');
                return;
            }

            jQuery.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'apply_coupon',
                    coupon_code: couponCode,
                    security: ajax_object.nonce
                },
                beforeSend: function() {
                    document.getElementById('apply_coupon').textContent = 'Uygulanıyor...';
                },
                success: function(response) {
                    if (response.success) {
                        checkout.coupons.showMessage('Kupon başarıyla uygulandı!', 'success');
                        loadCartContents();
                    } else {
                        checkout.coupons.showMessage(response.data.message || 'Kupon uygulanamadı.', 'error');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', error);
                    checkout.coupons.showMessage('Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
                },
                complete: function() {
                    document.getElementById('apply_coupon').textContent = 'Uygula';
                }
            });
        },

        showMessage: function(message, type) {
            const responseDiv = document.getElementById('coupon_response');
            responseDiv.innerHTML = message;
            responseDiv.className = `uk-text-small uk-text-${type === 'success' ? 'success' : 'danger'}`;
            responseDiv.style.display = 'block';

            setTimeout(() => {
                responseDiv.style.display = 'none';
            }, 3000);
        }
    }
};

document.addEventListener('DOMContentLoaded', function () {
    const addToCartBtn = document.getElementById('add-to-cart-btn');

    if (addToCartBtn) {
        addToCartBtn.addEventListener('click', function() {
            var productId = document.querySelector('input[name="product_id"]').value;
            var quantity = document.getElementById('input-quantity').value;

            // AJAX request to add product to cart
            var data = {
                action: 'add_to_cart',  // WordPress AJAX action hook
                product_id: productId,
                quantity: quantity
            };

            // Make the AJAX request
            jQuery.post(ajaxurl, data, function(response) {
                if (response.success) {
                    // Show cart modal after successful add
                    showCartModal();
                } else {
                    alert('There was an error adding the product to your cart.');
                }
            });
        });
    }
});

function showCartModal() {
    setTimeout(function () {
        UIkit.offcanvas('#offcanvas-basket').show();
    }, 750);
    loadCartContents();
}

function loadCartContents() {
    jQuery.post(ajaxurl, { action: 'get_cart_contents' }, function(response) {
        if (response.success) {
            var cartHtml = response.data.cart_html;
            document.getElementById('cart').innerHTML = cartHtml;
        }
    });
}


function removeFromCart(button) {
    var itemId = button.getAttribute('data-item-id');

    jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'remove_from_cart',
            item_id: itemId // Ürün ID'si
        },
        success: function(response) {
            if(response.success) {
                loadCartContents();
            }
        }
    });
}

function toggleFavorite(button) {
    var itemId = button.getAttribute('data-item-id');
    var action = button.classList.contains('added-to-favorites') ? 'remove_from_favorites' : 'add_to_favorites';

    jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: action,
            item_id: itemId // Ürün ID'si
        },
        success: function(response) {
            if(response.success) {
                updateFavoriteButton(button, action);
            }
        }
    });
}

function updateFavoriteButton(button, action) {
    if (action === 'add_to_favorites') {
        button.classList.add('added-to-favorites');
        button.textContent = 'Favorilerden Çıkar';
    } else {
        button.classList.remove('added-to-favorites');
        button.textContent = 'Favorilere Ekle';
    }
}

// Initialize coupon functionality
document.addEventListener('DOMContentLoaded', function() {
    checkout.coupons.init();
});

// Kupon kaldırma işlemi için event listener'ı güncelleyelim
document.addEventListener('DOMContentLoaded', function() {

    $('.remove-coupon').on('click', function(e) {
        e.preventDefault();
        var coupon_code = $(this).data('coupon');
        
        $.ajax({
            url: ajaxurl, // WooCommerce URL'i yerine kendi ajaxurl'inizi kullanın
            type: 'POST',
            data: {
                action: 'remove_coupon',
                security: ajax_object.nonce, // WooCommerce nonce yerine kendi nonce'unuzu kullanın
                coupon_code: coupon_code
            },
            beforeSend: function() {
                // İsteğe bağlı loading göstergesi
                console.log('Kupon kaldırılıyor...');
            },
            success: function(response) {
                if (response.success) {
                    loadCartContents(); // Sayfayı yenilemek yerine sepeti güncelleyin
                    checkout.coupons.showMessage('Kupon başarıyla kaldırıldı!', 'success');
                } else {
                    checkout.coupons.showMessage('Kupon kaldırılırken bir hata oluştu.', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                checkout.coupons.showMessage('Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
            }
        });
    });
});